/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.web.security.RequestFacadeWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.glassfish.grizzly.http.util.DataChunk;

class HttpRequestWrapper
implements HttpRequest,
ServletRequest {
    private final Request httpRequest;
    private final HttpServletRequest servletRequest;
    private final boolean isDefaultContext;
    private ServletRequest maskedFacade;
    private ServletRequest facade;

    HttpRequestWrapper(HttpRequest request, HttpServletRequest servletRequest) {
        this.httpRequest = (Request)request;
        this.servletRequest = servletRequest;
        this.isDefaultContext = this.httpRequest.getMappingData().isDefaultContext;
    }

    public void addCookie(Cookie cookie) {
        this.httpRequest.addCookie(cookie);
    }

    public void addHeader(String name, String value) {
        this.httpRequest.addHeader(name, value);
    }

    public void addLocale(Locale locale) {
        this.httpRequest.addLocale(locale);
    }

    public void addParameter(String name, String[] values) {
        this.httpRequest.addParameter(name, values);
    }

    public void clearCookies() {
        this.httpRequest.clearCookies();
    }

    public void clearHeaders() {
        this.httpRequest.clearHeaders();
    }

    public void clearLocales() {
        this.httpRequest.clearLocales();
    }

    public void clearParameters() {
        this.httpRequest.clearParameters();
    }

    public void replayPayload(byte[] payloadByteArray) {
        this.httpRequest.replayPayload(payloadByteArray);
    }

    public void setAuthType(String type) {
        this.httpRequest.setAuthType(type);
    }

    public void setMethod(String method) {
        this.httpRequest.setMethod(method);
    }

    public void setQueryString(String query) {
        this.httpRequest.setQueryString(query);
    }

    public Session getSessionInternal(boolean create) {
        return this.httpRequest.getSessionInternal(create);
    }

    public String changeSessionId() {
        return this.httpRequest.changeSessionId();
    }

    public void setPathInfo(String path) {
        this.httpRequest.setPathInfo(path);
    }

    public DataChunk getRequestPathMB() {
        return this.httpRequest.getRequestPathMB();
    }

    public void setRequestedSessionCookie(boolean flag) {
        this.httpRequest.setRequestedSessionCookie(flag);
    }

    public void setRequestedSessionCookiePath(String cookiePath) {
        this.httpRequest.setRequestedSessionCookiePath(cookiePath);
    }

    public void setRequestedSessionId(String id) {
        this.httpRequest.setRequestedSessionId(id);
    }

    public void setRequestedSessionURL(boolean flag) {
        this.httpRequest.setRequestedSessionURL(flag);
    }

    public void setRequestURI(String uri) {
        this.httpRequest.setRequestURI(uri);
    }

    public String getDecodedRequestURI() {
        return this.httpRequest.getDecodedRequestURI();
    }

    public void setServletPath(String path) {
        this.httpRequest.setServletPath(path);
    }

    public void setUserPrincipal(Principal principal) {
        this.httpRequest.setUserPrincipal(principal);
    }

    public String getAuthorization() {
        return this.httpRequest.getAuthorization();
    }

    public Connector getConnector() {
        return this.httpRequest.getConnector();
    }

    public void setConnector(Connector connector) {
        this.httpRequest.setConnector(connector);
    }

    public Context getContext() {
        return this.httpRequest.getContext();
    }

    public void setContext(Context context) {
        this.httpRequest.setContext(context);
    }

    public FilterChain getFilterChain() {
        return this.httpRequest.getFilterChain();
    }

    public void setFilterChain(FilterChain filterChain) {
        this.httpRequest.setFilterChain(filterChain);
    }

    public Host getHost() {
        return this.httpRequest.getHost();
    }

    public void setHost(Host host) {
        this.httpRequest.setHost(host);
    }

    public String getInfo() {
        return this.httpRequest.getInfo();
    }

    public ServletRequest getRequest() {
        return this.getRequest(false);
    }

    public ServletRequest getRequest(boolean maskDefaultContextMapping) {
        Object rvalue;
        boolean getMasked = maskDefaultContextMapping && this.isDefaultContext;
        ServletRequest servletRequest = rvalue = getMasked ? this.maskedFacade : this.facade;
        if (rvalue == null) {
            rvalue = new RequestFacadeWrapper(this.httpRequest, this.servletRequest, getMasked);
            if (getMasked) {
                this.maskedFacade = rvalue;
            } else {
                this.facade = rvalue;
            }
        }
        return rvalue;
    }

    public Response getResponse() {
        return this.httpRequest.getResponse();
    }

    public void setResponse(Response response) {
        this.httpRequest.setResponse(response);
    }

    public Socket getSocket() {
        return this.httpRequest.getSocket();
    }

    public void setSocket(Socket socket) {
        this.httpRequest.setSocket(socket);
    }

    public InputStream getStream() {
        return this.httpRequest.getStream();
    }

    public void setStream(InputStream stream) {
        this.httpRequest.setStream(stream);
    }

    public Wrapper getWrapper() {
        return this.httpRequest.getWrapper();
    }

    public void setWrapper(Wrapper wrapper) {
        this.httpRequest.setWrapper(wrapper);
    }

    public ServletInputStream createInputStream() throws IOException {
        return this.httpRequest.createInputStream();
    }

    public void finishRequest() throws IOException {
        this.httpRequest.finishRequest();
    }

    public Object getNote(String name) {
        return this.httpRequest.getNote(name);
    }

    public Iterator getNoteNames() {
        return this.httpRequest.getNoteNames();
    }

    public void recycle() {
        this.httpRequest.recycle();
    }

    public void removeNote(String name) {
        this.httpRequest.removeNote(name);
    }

    public void setContentLength(int length) {
        this.httpRequest.setContentLength(length);
    }

    public void setContentType(String type) {
        this.httpRequest.setContentType(type);
    }

    public void setNote(String name, Object value) {
        this.httpRequest.setNote(name, value);
    }

    public void setProtocol(String protocol) {
        this.httpRequest.setProtocol(protocol);
    }

    public void setRemoteAddr(String remote) {
        this.httpRequest.setRemoteAddr(remote);
    }

    public void setSecure(boolean secure) {
        this.httpRequest.setSecure(secure);
    }

    public void setServerName(String name) {
        this.httpRequest.setServerName(name);
    }

    public void setServerPort(int port) {
        this.httpRequest.setServerPort(port);
    }

    public void setCheckRestrictedResources(boolean check) {
        this.httpRequest.setCheckRestrictedResources(check);
    }

    public boolean getCheckRestrictedResources() {
        return this.httpRequest.getCheckRestrictedResources();
    }

    public String getJrouteId() {
        return this.httpRequest.getJrouteId();
    }

    public String generateSessionId() {
        return this.httpRequest.generateSessionId();
    }

    public void disableAsyncSupport() {
        this.httpRequest.disableAsyncSupport();
    }

    public Session lockSession() {
        return this.httpRequest.lockSession();
    }

    public void unlockSession() {
        this.httpRequest.unlockSession();
    }

    public Object getAttribute(String name) {
        return this.servletRequest.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.servletRequest.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.servletRequest.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.servletRequest.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.servletRequest.getContentLength();
    }

    public String getContentType() {
        return this.servletRequest.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.servletRequest.getInputStream();
    }

    public String getParameter(String name) {
        return this.servletRequest.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return this.servletRequest.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.servletRequest.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.servletRequest.getParameterMap();
    }

    public String getProtocol() {
        return this.servletRequest.getProtocol();
    }

    public String getScheme() {
        return this.servletRequest.getScheme();
    }

    public String getServerName() {
        return this.servletRequest.getServerName();
    }

    public int getServerPort() {
        return this.servletRequest.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.servletRequest.getReader();
    }

    public String getRemoteAddr() {
        return this.servletRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.servletRequest.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.servletRequest.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.servletRequest.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.servletRequest.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.servletRequest.getLocales();
    }

    public boolean isSecure() {
        return this.servletRequest.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.servletRequest.getRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return this.servletRequest.getRealPath(path);
    }

    public int getRemotePort() {
        return this.servletRequest.getRemotePort();
    }

    public String getLocalName() {
        return this.servletRequest.getLocalName();
    }

    public String getLocalAddr() {
        return this.servletRequest.getLocalAddr();
    }

    public int getLocalPort() {
        return this.servletRequest.getLocalPort();
    }

    public ServletContext getServletContext() {
        return this.servletRequest.getServletContext();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.servletRequest.startAsync();
    }

    public AsyncContext startAsync(ServletRequest sRequest, ServletResponse sResponse) throws IllegalStateException {
        return this.servletRequest.startAsync(sRequest, sResponse);
    }

    public boolean isAsyncStarted() {
        return this.servletRequest.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.servletRequest.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return this.servletRequest.getAsyncContext();
    }

    public DispatcherType getDispatcherType() {
        return this.servletRequest.getDispatcherType();
    }

    public long getContentLengthLong() {
        return this.servletRequest.getContentLengthLong();
    }
}

