/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.enablement;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.enablement.Item;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ListView;

abstract class EnablementListView
extends ListView<Item, Class<?>> {
    private static final String ADD_OPERATION = "adds";
    private static final String REMOVE_OPERATION = "removes";
    private static final String SET_OPERATION = "sets";
    private static final String RETAIN_OPERATION = "retains";
    private static final int DEFAULT_PRIORITY = 2500;

    EnablementListView() {
    }

    protected abstract ViewType getViewType();

    protected abstract Extension getExtension();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Class<?> element) {
        List list;
        Preconditions.checkNotNull(element);
        List list2 = list = this.getDelegate();
        synchronized (list2) {
            if (this.getExtension() != null) {
                BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), element, ADD_OPERATION, (Object)this.getViewType());
            }
            return list.add(this.createSource(element, list.isEmpty() ? null : (Item)list.get(list.size() - 1), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> set(int index, Class<?> element) {
        List list;
        Preconditions.checkNotNull(element);
        List list2 = list = this.getDelegate();
        synchronized (list2) {
            if (index < 0 || index >= list.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (this.getExtension() != null) {
                BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), element, SET_OPERATION, (Object)this.getViewType());
            }
            return this.toView(this.getDelegate().set(index, this.createSource(element, ((Item)list.get(index)).getPriority())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, Class<?> element) {
        List list;
        Preconditions.checkNotNull(element);
        List list2 = list = this.getDelegate();
        synchronized (list2) {
            Item next;
            if (index < 0 || index >= list.size()) {
                throw new IndexOutOfBoundsException();
            }
            Item previous = index > 0 ? (Item)list.get(index - 1) : null;
            Item item = next = index <= list.size() - 1 ? (Item)list.get(index) : null;
            if (this.getExtension() != null) {
                BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), element, ADD_OPERATION, (Object)this.getViewType());
            }
            list.add(index, this.createSource(element, previous, next));
        }
    }

    @Override
    public Class<?> remove(int index) {
        Item removedItem = (Item)this.getDelegate().remove(index);
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), removedItem.getClass(), REMOVE_OPERATION, (Object)this.getViewType());
        }
        return this.toView(removedItem);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), c, REMOVE_OPERATION, (Object)this.getViewType());
        }
        return this.getDelegate().removeAll(c);
    }

    @Override
    public boolean remove(Object o) {
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), o, REMOVE_OPERATION, (Object)this.getViewType());
        }
        return this.getDelegate().remove(o);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), c, RETAIN_OPERATION, (Object)this.getViewType());
        }
        return this.getDelegate().retainAll(c);
    }

    @Override
    public void clear() {
        if (this.getExtension() != null) {
            BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(this.getExtension(), "", "removes all classes", (Object)this.getViewType());
        }
        this.getDelegate().clear();
    }

    @Override
    protected Class<?> toView(Item source) {
        return source.getJavaClass();
    }

    @Override
    protected Item createSource(Class<?> view) {
        throw new UnsupportedOperationException();
    }

    private Item createSource(Class<?> view, Item previous, Item next) {
        return this.createSource(view, this.getPriority(previous, next));
    }

    private Item createSource(Class<?> view, int priority) {
        return new Item(view, priority);
    }

    private int getPriority(Item previous, Item next) {
        int priority;
        if (previous == null && next == null) {
            priority = 2500;
        } else if (previous != null && next != null) {
            int gap = next.getPriority() - previous.getPriority();
            if (gap == 0) {
                priority = next.getPriority();
            } else if (gap == 1) {
                for (Item item : this.getDelegate()) {
                    item.scalePriority();
                }
                priority = this.getPriority(previous, next);
            } else {
                priority = gap / 2 + previous.getPriority();
            }
        } else {
            priority = previous != null ? previous.getPriority() + 10 : next.getPriority() - 10;
        }
        return priority;
    }

    @Override
    public ListIterator<Class<?>> listIterator() {
        return new EnablementListViewIterator(this.getDelegate().listIterator());
    }

    @Override
    public ListIterator<Class<?>> listIterator(int index) {
        return new EnablementListViewIterator(this.getDelegate().listIterator(index));
    }

    static enum ViewType {
        ALTERNATIVES("getAlternatives()"),
        INTERCEPTORS("getInterceptors()"),
        DECORATORS("getDecorators()");

        private final String name;

        private ViewType(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    class EnablementListViewIterator
    extends ListView.ListViewIterator {
        private Item lastItem;

        public EnablementListViewIterator(ListIterator<Item> delegate) {
            super(EnablementListView.this, delegate);
        }

        @Override
        public Class<?> next() {
            this.lastItem = (Item)this.delegate.next();
            return EnablementListView.this.toView(this.lastItem);
        }

        @Override
        public Class<?> previous() {
            this.lastItem = (Item)this.delegate.previous();
            return EnablementListView.this.toView(this.lastItem);
        }

        @Override
        public void set(Class<?> clazz) {
            if (EnablementListView.this.getExtension() != null) {
                BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(EnablementListView.this.getExtension(), clazz, EnablementListView.SET_OPERATION, (Object)EnablementListView.this.getViewType());
            }
            this.delegate.set(EnablementListView.this.createSource(clazz, this.lastItem.getPriority()));
        }

        @Override
        public void add(Class<?> clazz) {
            Item next;
            Item previous = this.hasPrevious() ? (Item)EnablementListView.this.getDelegate().get(this.previousIndex()) : null;
            Item item = next = this.hasNext() ? (Item)EnablementListView.this.getDelegate().get(this.nextIndex()) : null;
            if (EnablementListView.this.getExtension() != null) {
                BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(EnablementListView.this.getExtension(), clazz, EnablementListView.ADD_OPERATION, (Object)EnablementListView.this.getViewType());
            }
            this.delegate.add(EnablementListView.this.createSource(clazz, previous, next));
        }

        @Override
        public void remove() {
            if (EnablementListView.this.getExtension() != null) {
                BootstrapLogger.LOG.typeModifiedInAfterTypeDiscovery(EnablementListView.this.getExtension(), ((Item)EnablementListView.this.getDelegate().get(this.delegate.nextIndex())).getJavaClass(), EnablementListView.REMOVE_OPERATION, (Object)EnablementListView.this.getViewType());
            }
            this.delegate.remove();
        }
    }
}

